package gov.va.vinci.dart.json;

import javax.xml.bind.annotation.XmlType;

import gov.va.vinci.dart.biz.Group;

@XmlType(name="Review", propOrder={
		"id",
		"groupName",
		"groupNameNoSpaces",
		"status",
		"statusClass",
		"daysElapsed",
		"medianDaysElapsed",
		"requestorDaysElapsed",
		"requestorMedianDaysElapsed",
		"sortOrder"
})
public class ReviewStatusView implements Comparable {

	private int id;
	private String groupName;
	private String groupNameNoSpaces;	//initial and final NDS review have spaces in the name
	
	private String status = "";
	private String statusClass = "";
	
	private String daysElapsed = "0.00";
	private String medianDaysElapsed = "0.00";	//formatted to 2 decimal places

	private String requestorDaysElapsed = "0.00";
	private String requestorMedianDaysElapsed = "0.00";	//formatted to 2 decimal places
	
	private int sortOrder;
	

	public int getId() {
		return id;
	}

	public void setId(int id) {
		this.id = id;
	}

	public String getGroupName() {
		return groupName;
	}

	public void setGroupName(String groupName) {
		this.groupName = groupName;
	}

	
	public String getGroupNameNoSpaces() {
		return groupNameNoSpaces;
	}

	public void setGroupNameNoSpaces(String groupNameNoSpaces) {
		this.groupNameNoSpaces = groupNameNoSpaces;
	}

	
	public String getStatus() {
		return status;
	}
	
	public void setStatus(String status) {
		this.status = status;
	}
	
	
	public String getStatusClass() {
		return statusClass;
	}

	public void setStatusClass(String statusClass) {
		this.statusClass = statusClass;
	}
	
	
	public String getDaysElapsed() {
		return daysElapsed;
	}
	
	public void setDaysElapsed(String daysElapsed) {
		this.daysElapsed = daysElapsed;
	}
	
	
	public String getMedianDaysElapsed() {
		return medianDaysElapsed;
	}
	
	public void setMedianDaysElapsed(String medianDaysElapsed) {
		this.medianDaysElapsed = medianDaysElapsed;
	}
	
	public String getRequestorDaysElapsed() {
		return requestorDaysElapsed;
	}

	public void setRequestorDaysElapsed(String requestorDaysElapsed) {
		this.requestorDaysElapsed = requestorDaysElapsed;
	}

	public String getRequestorMedianDaysElapsed() {
		return requestorMedianDaysElapsed;
	}

	public void setRequestorMedianDaysElapsed(String requestorMedianDaysElapsed) {
		this.requestorMedianDaysElapsed = requestorMedianDaysElapsed;
	}

		
	public int getSortOrder() {
		return sortOrder;
	}

	public void setSortOrder(int sortOrder) {
		this.sortOrder = sortOrder;
	}

	
	public static String formatTo2DecimalPlaces( double origValue ) {
		return (String.format("%.2f", origValue));
	}
	
	
	/**
	 * Returns a String containing the group name and review status. (Used for the review state validation).
	 * @return
	 */
	public String getStatusDisplayString() {
		return (groupName + ": " + status);		
	}
	
	
	/**
	 * Returns the sortOrder value for the specified group.  (Used for the review state validation and the wait time display.)
	 * @param group
	 * @param bIsInitial
	 * @return
	 */
	public static int getSortOrderForGroup( final Group group, final boolean bIsInitial ) {

		if( group != null ) {

			//NDS
			if( group.getId() == Group.NDS.getId() ) {
				if( bIsInitial )
					return 0;	//initial NDS review
				else
					return 100;	//final NDS review
			}//end if
			
			
			//sort order:  Privacy, Security, ORD, others
			if( group.getId() == Group.PRIVACY.getId() )
				return 1;
			else if( group.getId() == Group.SECURITY.getId() )
				return 2;
			else if( group.getId() == Group.ORD.getId() )
				return 3;
			
			return 10;	//other intermediate review
		}//end if
		
		return 0;
	}

	
	/**
	 * Compares the ReviewStatusView objects, based on the sortOrder value.
	 */
	@Override
	public int compareTo(Object o) {
		if (o == null) {
			return -1;
		}
		if (ReviewStatusView.class.isAssignableFrom(o.getClass()) == false) {
			return -1;
		}
		
		ReviewStatusView view2 = (ReviewStatusView)o;

		if (view2.sortOrder == this.sortOrder) {
			return 0;
		}
		return (view2.sortOrder < this.sortOrder) ? 1: -1;
	}	
	
	
	// Match, based on groupName
	// necessary to use (List<ReviewStatusView>).contains()
	@Override
	public boolean equals(Object obj) {
		if (obj == null) {
			return false;
		}
		
		if ((obj instanceof ReviewStatusView) == false) {
			return false;
		}
		
		ReviewStatusView rs2 = (ReviewStatusView)obj;		
		if( rs2.groupName != null && groupName != null )
			return rs2.groupName.equalsIgnoreCase(groupName);
		
		return false;
	}
}
